/*
 * Decompiled with CFR 0.152.
 */
package net.firemuffin303.thaidelight.forge;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.List;
import net.firemuffin303.thaidelight.ThaiDelight;
import net.firemuffin303.thaidelight.common.entity.Dragonfly;
import net.firemuffin303.thaidelight.common.entity.FlowerCrabEntity;
import net.firemuffin303.thaidelight.common.event.ModVillagerTrades;
import net.firemuffin303.thaidelight.common.item.bottle.DragonflyBottleItem;
import net.firemuffin303.thaidelight.common.registry.ModBlocks;
import net.firemuffin303.thaidelight.common.registry.ModEntityTypes;
import net.firemuffin303.thaidelight.common.registry.ModFluid;
import net.firemuffin303.thaidelight.common.registry.ModItems;
import net.firemuffin303.thaidelight.common.registry.ModMenuType;
import net.firemuffin303.thaidelight.common.registry.ModRecipes;
import net.firemuffin303.thaidelight.common.registry.ModSoundEvents;
import net.firemuffin303.thaidelight.common.registry.ModTreeDecorator;
import net.firemuffin303.thaidelight.forge.common.Configuration;
import net.firemuffin303.thaidelight.forge.common.registry.ModBlocksForge;
import net.firemuffin303.thaidelight.forge.common.registry.ModItemsForge;
import net.firemuffin303.thaidelight.forge.common.structures.VillageStructures;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.event.entity.SpawnPlacementRegisterEvent;
import net.minecraftforge.event.village.VillagerTradesEvent;
import net.minecraftforge.event.village.WandererTradesEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegisterEvent;

@Mod(value="muffins_thaidelight")
public class ThaiDelightForge {
    public static final DeferredRegister<BlockEntityType<?>> BLOCK_ENTITY_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCK_ENTITY_TYPES, (String)"muffins_thaidelight");
    public static final DeferredRegister<Block> BLOCK = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"muffins_thaidelight");
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"muffins_thaidelight");
    public static final DeferredRegister<EntityType<?>> ENTITY_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITY_TYPES, (String)"muffins_thaidelight");
    public static final DeferredRegister<Fluid> FLUIDS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.FLUIDS, (String)"muffins_thaidelight");
    public static final DeferredRegister<RecipeType<?>> RECIPE_TYPE = DeferredRegister.create((IForgeRegistry)ForgeRegistries.RECIPE_TYPES, (String)"muffins_thaidelight");
    public static final DeferredRegister<RecipeSerializer<?>> RECIPE_SERIALIZER = DeferredRegister.create((IForgeRegistry)ForgeRegistries.RECIPE_SERIALIZERS, (String)"muffins_thaidelight");
    public static final DeferredRegister<MenuType<?>> MENU_TYPE = DeferredRegister.create((IForgeRegistry)ForgeRegistries.MENU_TYPES, (String)"muffins_thaidelight");
    public static final DeferredRegister<SoundEvent> SOUND_EVENT = DeferredRegister.create((IForgeRegistry)ForgeRegistries.SOUND_EVENTS, (String)"muffins_thaidelight");
    public static final DeferredRegister<TreeDecoratorType<?>> TREE_DECORATOR = DeferredRegister.create((IForgeRegistry)ForgeRegistries.TREE_DECORATOR_TYPES, (String)"muffins_thaidelight");

    public ThaiDelightForge() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.register((Object)this);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Configuration.COMMON_CONFIG);
        ENTITY_TYPES.register(modEventBus);
        BLOCK.register(modEventBus);
        BLOCK_ENTITY_TYPES.register(modEventBus);
        FLUIDS.register(modEventBus);
        ITEMS.register(modEventBus);
        RECIPE_TYPE.register(modEventBus);
        RECIPE_SERIALIZER.register(modEventBus);
        MENU_TYPE.register(modEventBus);
        SOUND_EVENT.register(modEventBus);
        TREE_DECORATOR.register(modEventBus);
        modEventBus.addListener(EventPriority.HIGH, this::registerEvent);
        modEventBus.addListener(EventPriority.LOW, this::registerAttribute);
        modEventBus.addListener(EventPriority.LOW, this::registerEntitySpawn);
        modEventBus.addListener(EventPriority.LOW, this::registerCommonSetup);
        MinecraftForge.EVENT_BUS.addListener(VillageStructures::addNewVillageBuilding);
        MinecraftForge.EVENT_BUS.addListener(this::registerVillagerTrades);
        MinecraftForge.EVENT_BUS.addListener(this::registerWandererTrades);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public void registerAttribute(EntityAttributeCreationEvent event) {
        ModEntityTypes.registerAttributes((supplier, builderSupplier) -> event.put((EntityType)supplier.get(), ((AttributeSupplier.Builder)builderSupplier.get()).m_22265_()));
    }

    public void registerEntitySpawn(SpawnPlacementRegisterEvent spawnPlacements) {
        spawnPlacements.register(ModEntityTypes.FLOWER_CRAB, SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, FlowerCrabEntity::checkSpawnRules, SpawnPlacementRegisterEvent.Operation.AND);
        spawnPlacements.register(ModEntityTypes.DRAGONFLY, SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Mob::m_217057_, SpawnPlacementRegisterEvent.Operation.AND);
    }

    public void registerEvent(RegisterEvent registerEvent) {
        registerEvent.register(ForgeRegistries.Keys.ENTITY_TYPES, helper -> ModEntityTypes.init());
        registerEvent.register(ForgeRegistries.Keys.BLOCKS, helper -> {
            ModBlocks.init();
            ModBlocksForge.init();
        });
        registerEvent.register(ForgeRegistries.Keys.BLOCK_ENTITY_TYPES, helper -> ModBlocks.ModBlockEntityTypes.init());
        registerEvent.register(ForgeRegistries.Keys.FLUIDS, helper -> ModFluid.init());
        registerEvent.register(ForgeRegistries.Keys.ITEMS, helper -> {
            ModItems.init();
            ModItemsForge.init();
        });
        registerEvent.register(ForgeRegistries.Keys.RECIPE_TYPES, helper -> ModRecipes.init());
        registerEvent.register(ForgeRegistries.Keys.RECIPE_SERIALIZERS, helper -> ModRecipes.ModRecipeSerializer.init());
        registerEvent.register(ForgeRegistries.Keys.MENU_TYPES, helper -> ModMenuType.init());
        registerEvent.register(ForgeRegistries.Keys.SOUND_EVENTS, helper -> ModSoundEvents.init());
        registerEvent.register(ForgeRegistries.Keys.TREE_DECORATOR_TYPES, helper -> ModTreeDecorator.init());
        registerEvent.register(Registries.f_279569_, helper -> Registry.m_122965_((Registry)BuiltInRegistries.f_279662_, (ResourceLocation)new ResourceLocation("muffins_thaidelight", "main"), (Object)CreativeModeTab.builder().m_257941_((Component)Component.m_237115_((String)"itemGroup.muffins_thaidelight.main")).m_257737_(() -> new ItemStack((ItemLike)ModBlocks.MORTAR)).m_257501_(this::displayItem).m_257652_()));
    }

    public void registerCommonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(ThaiDelight::registerComposterBlock);
        event.enqueueWork(ThaiDelight::registerStrippables);
        event.enqueueWork(ThaiDelight::registerAnimalFoodItem);
    }

    public void registerVillagerTrades(VillagerTradesEvent event) {
        ModVillagerTrades.trades().forEach(modVillagerTrade -> {
            if (event.getType() == modVillagerTrade.villagerProfession()) {
                Int2ObjectMap trades = event.getTrades();
                ((List)trades.get(modVillagerTrade.level())).add((arg, arg2) -> modVillagerTrade.merchantOffer());
            }
        });
    }

    public void registerWandererTrades(WandererTradesEvent event) {
        ModVillagerTrades.wanderTrade().forEach(integerMerchantOfferPair -> event.getGenericTrades().add((arg, arg2) -> integerMerchantOfferPair));
    }

    public void displayItem(CreativeModeTab.ItemDisplayParameters itemDisplayParameters, CreativeModeTab.Output output) {
        Dragonfly.DragonflyVariant[] dragonflyVariants;
        output.m_246326_((ItemLike)ModBlocks.MORTAR);
        output.m_246326_((ItemLike)ModBlocks.LIME_CRATE);
        output.m_246326_((ItemLike)ModBlocks.PEPPER_CRATE);
        output.m_246326_((ItemLike)ModBlocks.RAW_PAPAYA_CRATE);
        output.m_246326_((ItemLike)ModBlocks.PAPAYA_CRATE);
        output.m_246326_((ItemLike)ModBlocks.PAPAYA_LOG);
        output.m_246326_((ItemLike)ModBlocks.PAPAYA_WOOD);
        output.m_246326_((ItemLike)ModBlocks.STRIPPED_PAPAYA_LOG);
        output.m_246326_((ItemLike)ModBlocks.STRIPPED_PAPAYA_WOOD);
        output.m_246326_((ItemLike)ModBlocks.PAPAYA_LEAVES);
        output.m_246326_((ItemLike)ModBlocks.SOMTAM_FEAST);
        output.m_246326_((ItemLike)ModBlocks.SPICY_MINCED_MEAT_SALAD_FEAST);
        output.m_246326_((ItemLike)ModBlocks.CRAB_FRIED_RICE_FEAST);
        output.m_246326_((ItemLike)ModBlocks.WILD_PEPPER_CROP);
        output.m_246326_((ItemLike)ModItems.PEPPER);
        output.m_246326_((ItemLike)ModItems.PEPPER_SEED);
        output.m_246326_((ItemLike)ModItems.LIME);
        output.m_246326_((ItemLike)ModItems.SLICED_LIME);
        output.m_246326_((ItemLike)ModBlocks.LIME_SAPLING);
        output.m_246326_((ItemLike)ModItems.PAPAYA);
        output.m_246326_((ItemLike)ModItems.SLICED_PAPAYA);
        output.m_246326_((ItemLike)ModItems.RAW_PAPAYA);
        output.m_246326_((ItemLike)ModItems.RAW_PAPAYA_SLICE);
        output.m_246326_((ItemLike)ModBlocks.PAPAYA_SAPLING);
        output.m_246326_((ItemLike)ModItems.PAPAYA_SEEDS);
        output.m_246326_((ItemLike)ModItemsForge.SOMTAM.get());
        output.m_246326_((ItemLike)ModItemsForge.SPICY_MINCED_MEAT_SALAD.get());
        output.m_246326_((ItemLike)ModItemsForge.CRAB_FRIED_RICE.get());
        output.m_246326_((ItemLike)ModItemsForge.STIR_FRIED_NOODLE.get());
        output.m_246326_((ItemLike)ModItems.LIME_JUICE);
        output.m_246326_((ItemLike)ModItems.PAPAYA_JUICE);
        output.m_246326_((ItemLike)ModItems.FISH_SAUCE_BOTTLE);
        output.m_246326_((ItemLike)ModItems.CRAB_SPAWN_EGG);
        output.m_246326_((ItemLike)ModBlocks.CRAB_EGG);
        output.m_246326_((ItemLike)ModItems.CRAB_BUCKET);
        output.m_246326_((ItemLike)ModItems.CRAB_MEAT);
        output.m_246326_((ItemLike)ModItems.COOKED_CRAB_MEAT);
        output.m_246326_((ItemLike)ModItems.DRAGONFLY_SPAWN_EGG);
        for (Dragonfly.DragonflyVariant variant : dragonflyVariants = Dragonfly.DragonflyVariant.values()) {
            ItemStack itemStack = new ItemStack((ItemLike)ModItems.DRAGONFLY_BOTTLE);
            DragonflyBottleItem.setVariant(itemStack, variant);
            output.m_246342_(itemStack);
        }
        output.m_246326_((ItemLike)ModItems.DRAGONFLY);
        output.m_246326_((ItemLike)ModItems.COOKED_DRAGONFLY);
    }
}

